﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


/* Operations not available to query syntax  */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        /*  Aggregation operations: Sum() and Aggregate() */
        private void button1_Click(object sender, EventArgs e)
        {
            int[] numbers = { 0, 8, 5, 2, 9, 3, 7, 1, 6, 4 };


            int sum = numbers.Sum();   
            MessageBox.Show(sum.ToString());



            /* using the Aggregate() which allows for custom aggregation 
             
               The Aggregate() uses a generic delegate of type
                    delegate TResult Func<T1, T2, TResult>(T1 arg1, T2 arg2);
             
               The first parameter passed, total in this example, is the current total of the operation.
               The second parameter passed is the current element.
               
               So this example here sums even numbers only and ignore the odd ones.
              */
            sum = numbers.Aggregate((total, n) => total += n % 2 == 0 ? n : 0);
            MessageBox.Show(sum.ToString());
        }




        /* Data type convertion operations: ToLookup() */
        private void button2_Click(object sender, EventArgs e)
        {
            int[] numbers = { 0, 8, 5, 2, 9, 3, 7, 1, 6, 4 };

            
            // the key is a bool value, odd and even numbers.
            // The Lookup() method creates a sub-list for each key
            ILookup<bool, int> lk = numbers.ToLookup(n => n % 2 == 0);



            // get the sub-list for odd numbers
            IEnumerable<int> list = lk[false];

            string S = "odd numbers" + Environment.NewLine;

            foreach (int n in list)
                S += "   " + n.ToString() + Environment.NewLine;



            // get the sub-list for even numbers
            list = lk[true];

            S += "even numbers" + Environment.NewLine;

            foreach (int n in list)
                S += "   " + n.ToString() + Environment.NewLine;


            MessageBox.Show(S);

        }




        /* Set operations: Intersect() 
           Element operations: Last() */
        private void button3_Click(object sender, EventArgs e)
        {
            int[] a = { 2, 9, 6, 4, 7};
            int[] b = { 7, 1, 8, 5, 9 };


            var v = a.Intersect(b);

            string S = "";

            foreach (int n in v)
            {
                S += n.ToString();

                if (n != v.Last())
                    S += ", ";
            }

            MessageBox.Show(S);
            
         
        }
    }
}
